/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.layers.elytra;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.mixin.render.layers.elytra.ElytraModelAccessor;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.PlatformUtils;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraLayer.class})
public abstract class ElytraLayerMixin<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Shadow
    @Final
    private ElytraModel<T> elytraModel;
    @Shadow
    @Final
    private static ResourceLocation WINGS_LOCATION;
    @Unique
    private VanillaPart vanillaPart;
    @Unique
    private Avatar figura$avatar;
    @Unique
    private boolean renderedPivot;

    public ElytraLayerMixin(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void setAvatar(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        this.figura$avatar = AvatarManager.getAvatar(livingEntity);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/ElytraModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", shift=At.Shift.AFTER)}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void onRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        this.vanillaPart = null;
        if (this.figura$avatar == null) {
            return;
        }
        if (this.figura$avatar.luaRuntime != null) {
            VanillaGroupPart part = this.figura$avatar.luaRuntime.vanilla_model.ELYTRA;
            ((VanillaPart)part).save((EntityModel<?>)this.elytraModel);
            if (this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                this.vanillaPart = part;
                this.vanillaPart.preTransform((EntityModel<?>)this.elytraModel);
            }
        }
        this.figura$avatar.elytraRender((Entity)livingEntity, multiBufferSource, poseStack, light, tickDelta, (EntityModel<?>)this.elytraModel);
        if (this.vanillaPart != null) {
            this.vanillaPart.posTransform((EntityModel<?>)this.elytraModel);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/ElytraModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, cancellable=true)
    public void cancelVanillaPart(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        if (this.vanillaPart != null) {
            this.vanillaPart.restore((EntityModel<?>)this.elytraModel);
        }
        this.renderedPivot = true;
        this.renderElytraPivot(poseStack, multiBufferSource, light, livingEntity, limbAngle, limbDistance, tickDelta, animationProgress);
        if (this.renderedPivot) {
            poseStack.popPose();
            ci.cancel();
        }
    }

    public void renderElytraPivot(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress) {
        ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (!itemStack.is(Items.ELYTRA) && !PlatformUtils.isModLoaded("origins")) {
            return;
        }
        if (this.figura$avatar != null && this.figura$avatar.luaRuntime != null && this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1 && this.figura$avatar.luaRuntime.vanilla_model.ELYTRA.checkVisible()) {
            boolean rightWing;
            boolean leftWing;
            AbstractClientPlayer abstractClientPlayer;
            this.elytraModel.setupAnim(livingEntity, limbAngle, limbDistance, tickDelta, (float)light, animationProgress);
            VanillaPart part = RenderUtils.pivotToPart(this.figura$avatar, ParentType.LeftElytraPivot);
            ResourceLocation resourceLocation = livingEntity instanceof AbstractClientPlayer ? ((abstractClientPlayer = (AbstractClientPlayer)livingEntity).getSkin().elytraTexture() != null ? abstractClientPlayer.getSkin().elytraTexture() : (abstractClientPlayer.getSkin().capeTexture() != null && abstractClientPlayer.isModelPartShown(PlayerModelPart.CAPE) ? abstractClientPlayer.getSkin().capeTexture() : WINGS_LOCATION)) : WINGS_LOCATION;
            VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)resourceLocation), (boolean)itemStack.hasFoil());
            if (part != null && part.checkVisible() && !(leftWing = this.figura$avatar.pivotPartRender(ParentType.LeftElytraPivot, stack -> {
                stack.pushPose();
                stack.scale(16.0f, 16.0f, 16.0f);
                stack.mulPose(Axis.XP.rotationDegrees(180.0f));
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.translate(0.0f, 0.0f, 0.125f);
                ((ElytraModelAccessor)this.elytraModel).getLeftWing().render(stack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
                stack.popPose();
            }))) {
                ((ElytraModelAccessor)this.elytraModel).getLeftWing().render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
            }
            if ((part = RenderUtils.pivotToPart(this.figura$avatar, ParentType.RightElytraPivot)) != null && part.checkVisible() && !(rightWing = this.figura$avatar.pivotPartRender(ParentType.RightElytraPivot, stack -> {
                stack.pushPose();
                stack.scale(16.0f, 16.0f, 16.0f);
                stack.mulPose(Axis.XP.rotationDegrees(180.0f));
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.translate(0.0f, 0.0f, 0.125f);
                ((ElytraModelAccessor)this.elytraModel).getRightWing().render(stack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
                stack.popPose();
            }))) {
                ((ElytraModelAccessor)this.elytraModel).getRightWing().render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
            }
        } else {
            this.renderedPivot = this.figura$avatar != null && this.figura$avatar.luaRuntime != null && this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1 && !this.figura$avatar.luaRuntime.vanilla_model.ELYTRA.checkVisible();
        }
    }
}

